/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.receiver.gui;

import java.awt.Insets;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import org.jchains.internal.Util;
import org.jchains.receiver.Perm;
import org.jchains.receiver.PolicyFile;
import org.jchains.receiver.gui.PermTableModel;
import org.jchains.receiver.gui.ReceiverForm;

public class UpdateTask
extends SwingWorker<Void, Void>
implements PropertyChangeListener {
    static boolean DEBUG = Boolean.parseBoolean(System.getProperty("org.jchains.debug", "false"));
    ReceiverForm theComp = null;
    ProgressMonitor progressMonitor = null;
    PolicyFile pf = null;
    JButton jb;
    int anzahl = 0;
    JTextArea taskOutput;
    File theFile = null;

    public UpdateTask(ReceiverForm c, ProgressMonitor pm, File f, JButton _jb, PolicyFile _pf) {
        this.theComp = c;
        this.progressMonitor = pm;
        this.jb = _jb;
        this.pf = _pf;
        this.theFile = f;
        this.addPropertyChangeListener(this);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
    }

    @Override
    public void done() {
        Toolkit.getDefaultToolkit().beep();
        this.jb.setEnabled(true);
        this.progressMonitor.setNote("finished with ");
        int wait = 1500;
        Util.waitMillis(wait);
        this.progressMonitor.setProgress(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void doInBackground() {
        System.out.println("Import triggered");
        PermTableModel pt = (PermTableModel)this.theComp.getTabPermission().getModel();
        int i = 0;
        this.setProgress(0);
        int progress = 0;
        FileInputStream f = null;
        try {
            f = new FileInputStream(this.theFile);
            int lauf = 0;
            BufferedReader br = new BufferedReader(new InputStreamReader(f));
            boolean ende = false;
            int delta = 1;
            pt.setPerms(new Vector<Perm>(0));
            while (!ende) {
                this.setProgress((progress += delta) / 100);
                delta = this.deltaFromProgress(progress, delta);
                String z = br.readLine();
                Perm pp = null;
                try {
                    pp = new Perm(z);
                }
                catch (Exception e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    ende = true;
                }
                if (!ende) {
                    pt.addPerm(pp);
                    this.pf.add(pp);
                    ++lauf;
                }
                this.anzahl = ++i;
            }
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                f.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.anzahl = i;
        pt.fireTableDataChanged();
        System.out.println("Import ended:" + i);
        this.progressMonitor.setNote("Import ended:" + i + " Permissions");
        return null;
    }

    private int deltaFromProgress(int progress, int delta) {
        if (progress == 10000) {
            delta = -1;
        } else if (progress == 0) {
            delta = 1;
        }
        return delta;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressMonitor.setProgress(progress);
            String message = String.format("Read : %d permissions.\n", this.anzahl);
            this.progressMonitor.setNote(message);
            this.taskOutput.append(message);
            if (this.progressMonitor.isCanceled() || this.isDone()) {
                Toolkit.getDefaultToolkit().beep();
                if (this.progressMonitor.isCanceled()) {
                    this.cancel(true);
                    this.taskOutput.append("Task canceled.\n");
                } else {
                    this.taskOutput.append("Task completed.\n");
                }
                this.jb.setEnabled(true);
            }
        }
    }
}

