/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.receiver.gui;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jchains.receiver.gui.MyPermissionsRender;
import org.jchains.receiver.gui.PermTableModel;

public class PermissionsTable
extends JTable {
    TableRowSorter<PermTableModel> sorter;
    String filter;
    FilterableTableModel filterableTableModel;
    int filterColumn = 3;
    int currentFilterMatches;
    int[] currentFilterMapping;
    static String[] strTooltips = new String[]{"The time the event occurred", "The codebase that required the permission", "The permission that was requested", "The privileged resource", "The action on the privileged resource", "The class in which the privileged access occurred", "The method in with the privileged access occurred", "The line in which the privileged access occurred (requires linenumbertable attribute)"};
    private static final long serialVersionUID = 1L;
    static MyPermissionsRender MyP = new MyPermissionsRender(true);
    static final String DEFAULT_FILTER = "^#.*";
    String oldfilter = "";

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return MyP;
    }

    public PermissionsTable() {
        PermTableModel ptm = new PermTableModel();
        this.setModel(ptm);
        this.filterableTableModel = new FilterableTableModel(ptm);
        this.setAutoResizeMode(0);
        int[] colwidth = new int[]{100, 250, 250, 350, 100, 250, 250, 100};
        for (int i = 0; i < colwidth.length; ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            col.setPreferredWidth(colwidth[i]);
        }
        this.setSelectionMode(0);
        this.setFillsViewportHeight(true);
        this.setAutoCreateRowSorter(true);
        this.sorter = new TableRowSorter<PermTableModel>(ptm);
        this.setRowSorter(this.sorter);
    }

    public int getFilterColumn() {
        return this.filterColumn;
    }

    public void setFilterColumn(int currentFilterColumn) {
        this.filterColumn = currentFilterColumn;
    }

    public int[] getCurrentFilterMapping() {
        return this.currentFilterMapping;
    }

    public void setCurrentFilterMapping(int[] currentFilterMapping) {
        this.currentFilterMapping = currentFilterMapping;
    }

    public int getCurrentFilterMatches() {
        return this.currentFilterMatches;
    }

    public void setCurrentFilterMatches(int currentFilterMatches) {
        this.currentFilterMatches = currentFilterMatches;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        String tmpfilter = DEFAULT_FILTER.replace("#", filter);
        System.out.println("filter set:" + tmpfilter);
        this.filter = tmpfilter;
        this.doFilter();
        this.updateUI();
    }

    public FilterableTableModel getFilterableTableModel() {
        return this.filterableTableModel;
    }

    public void setFilterableTableModel(FilterableTableModel filterableTableModel) {
        this.filterableTableModel = filterableTableModel;
    }

    private void doFilter() {
        this.currentFilterMatches = 0;
        TableModel model = super.getModel();
        int rowCount = model.getRowCount();
        int[] tmpMapping = new int[rowCount];
        int j = 0;
        for (int i = 0; i < rowCount; ++i) {
            if (!model.getValueAt(i, this.filterColumn).toString().matches(this.filter)) continue;
            ++this.currentFilterMatches;
            tmpMapping[j++] = i;
        }
        this.currentFilterMapping = new int[this.currentFilterMatches];
        System.arraycopy(tmpMapping, 0, this.currentFilterMapping, 0, this.currentFilterMatches);
        this.filterableTableModel.setFilterMapping(this.currentFilterMapping);
    }

    @Override
    public TableModel getModel() {
        TableModel tm = super.getModel();
        if (this.filter == null || this.filter.equals("")) {
            return tm;
        }
        if (this.filterableTableModel == null) {
            this.doFilter();
            this.setEditingRow(0);
        }
        return this.filterableTableModel;
    }

    public TableRowSorter<PermTableModel> getSorter() {
        return this.sorter;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return strTooltips[realIndex];
            }
        };
    }

    static class FilterableTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        TableModel delegateTableModel;
        int[] filterMapping;

        public FilterableTableModel(TableModel delegateTableModel) {
            this.delegateTableModel = delegateTableModel;
        }

        @Override
        public int getRowCount() {
            return this.filterMapping != null ? this.filterMapping.length : 0;
        }

        @Override
        public int getColumnCount() {
            return this.delegateTableModel.getColumnCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.filterMapping.length > rowIndex) {
                return this.delegateTableModel.getValueAt(this.filterMapping[rowIndex], columnIndex);
            }
            return "";
        }

        public int[] getFilterMapping() {
            return this.filterMapping;
        }

        public void setFilterMapping(int[] filterMapping) {
            this.filterMapping = filterMapping;
        }

        public TableModel getDelegateTableModel() {
            return this.delegateTableModel;
        }

        public void setDelegateTableModel(TableModel delegate) {
            this.delegateTableModel = delegate;
        }

        public void removeRow(int idx) {
            if (!(this.delegateTableModel instanceof DefaultTableModel)) {
                throw new UnsupportedOperationException();
            }
            ((DefaultTableModel)this.delegateTableModel).removeRow(this.filterMapping[idx]);
        }
    }
}

