/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.receiver.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

class MyPermissionsRender
extends JLabel
implements TableCellRenderer {
    boolean isBordered = false;
    Border unselBorder = null;
    Border selBorder = null;

    public MyPermissionsRender(boolean _isBordered) {
        this.isBordered = _isBordered;
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String curval = (String)table.getModel().getValueAt(row, column);
        String type = (String)table.getModel().getValueAt(row, 2);
        Color normalback = table.getBackground();
        Color normalfore = table.getForeground();
        if (type.endsWith("FilePermission")) {
            normalback = Color.lightGray;
        }
        if (type.endsWith("PropertyPermission")) {
            normalback = Color.blue.brighter().brighter().brighter().brighter();
            normalfore = Color.white;
        }
        if (type.endsWith("RuntimePermission")) {
            normalback = Color.yellow;
        }
        if (type.startsWith("javax.security") || type.startsWith("java.security")) {
            normalback = Color.red;
            normalfore = Color.white;
        }
        if (type.startsWith("javax.management")) {
            normalfore = Color.magenta;
        }
        this.setBackground(normalback);
        this.setForeground(normalfore);
        this.setText(curval);
        if (this.isBordered) {
            if (isSelected) {
                if (this.selBorder == null) {
                    this.selBorder = BorderFactory.createMatteBorder(1, 4, 1, 4, Color.RED);
                }
                this.setBorder(this.selBorder);
            } else {
                if (this.unselBorder == null) {
                    this.unselBorder = BorderFactory.createMatteBorder(1, 4, 1, 4, table.getBackground());
                }
                this.setBorder(this.unselBorder);
            }
        }
        this.setToolTipText(curval);
        return this;
    }
}

