/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.receiver.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.RowFilter;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.jchains.CORBA.PermissionTransferPackage.EnvironmentEntry;
import org.jchains.internal.Util;
import org.jchains.receiver.PolicyFile;
import org.jchains.receiver.gui.PermTableModel;
import org.jchains.receiver.gui.ReceiverForm;
import org.jchains.receiver.gui.UpdateTask;

public class GUIManagement
implements ActionListener {
    private ReceiverForm frm_rf;
    PolicyFile pf = new PolicyFile("", new EnvironmentEntry[0]);
    ProgressMonitor progressMonitor;
    UpdateTask task;
    JButton jb1;
    JButton jb2;
    DefaultTableModel dtm;
    EnvironmentEntry[] pe;
    JTextField tf;
    JTextField status;
    JComboBox cboSelectFilterColumn;

    public ReceiverForm getReceiverForm() {
        return this.frm_rf;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        System.out.println(ae);
        if (ae.getSource() == this.jb1) {
            JFileChooser fc = new JFileChooser(".");
            int returnVal = fc.showOpenDialog(this.frm_rf);
            File f = null;
            if (returnVal == 0) {
                f = fc.getSelectedFile();
                System.out.println("Opening: " + f.getName() + ".");
            } else {
                f = new File(System.getProperty("org.jchains.file", "permissions.csv"));
                System.out.println("Open command cancelled by user.");
            }
            this.progressMonitor = new ProgressMonitor(this.frm_rf, "Importing Permissions", "", 0, 100);
            this.progressMonitor.setProgress(0);
            this.task = new UpdateTask(this.frm_rf, this.progressMonitor, f, this.jb1, this.pf);
            this.task.execute();
            this.jb1.setEnabled(false);
        } else {
            String t = this.pf.getContent(false);
            this.getReceiverForm().getFieldTxtPolicyFile().setText(t);
        }
    }

    private void newFilter(TableRowSorter<PermTableModel> trs) {
        RowFilter rf = null;
        try {
            rf = RowFilter.regexFilter(this.tf.getText(), new int[0]);
        }
        catch (PatternSyntaxException e) {
            System.out.println("error with pattern:" + this.tf.getText());
            return;
        }
        trs.setRowFilter(rf);
    }

    public void initGUI(EnvironmentEntry[] _pe) {
        this.pe = _pe;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        this.frm_rf = new ReceiverForm();
        this.frm_rf.setTitle("jChains Receiver");
        this.frm_rf.getTxtAbout().setText("jChains v1.70 written by Marc Schoenefeld \r\nsee www.jchains.org for news");
        this.frm_rf.requestFocus();
        this.frm_rf.getFieldTxtMode().setText("started");
        TableRowSorter<PermTableModel> trs = this.frm_rf.tbPermissions.getSorter();
        JPanel jp = new JPanel(new SpringLayout());
        this.jb1 = new JButton("Import file");
        this.frm_rf.add(jp);
        jp.add(this.jb1);
        this.cboSelectFilterColumn = new JComboBox<String>(PermTableModel.getColumnNames());
        this.cboSelectFilterColumn.setSelectedIndex(this.frm_rf.tbPermissions.getFilterColumn());
        this.cboSelectFilterColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GUIManagement)GUIManagement.this).frm_rf.tbPermissions.setFilterColumn(GUIManagement.this.cboSelectFilterColumn.getSelectedIndex());
            }
        });
        jp.add(this.cboSelectFilterColumn);
        this.tf = new JTextField();
        this.tf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                ((GUIManagement)GUIManagement.this).frm_rf.tbPermissions.setFilter(GUIManagement.this.tf.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                ((GUIManagement)GUIManagement.this).frm_rf.tbPermissions.setFilter(GUIManagement.this.tf.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                ((GUIManagement)GUIManagement.this).frm_rf.tbPermissions.setFilter(GUIManagement.this.tf.getText());
            }
        });
        jp.add(this.tf);
        this.jb2 = new JButton("Gen Policy");
        jp.add(this.jb2);
        this.jb2.addActionListener(this);
        Util.makeCompactGrid(jp, 4, 1, 6, 6, 6, 6);
        this.jb1.addActionListener(this);
        try {
            this.dtm = new DefaultTableModel(new String[]{"Key", "Value"}, 0);
            JTable t = new JTable();
            t.setModel(this.dtm);
            this.frm_rf.setTabEnvironment(t);
        }
        catch (Exception e) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(bos, true);
            e.printStackTrace(pw);
            this.frm_rf.getFieldTxtPolicyFile().setText(bos.toString());
            System.out.println(bos.toString());
        }
        this.setResizeOn(this.frm_rf.getTabEnvironment());
        this.setEnvTable(this.dtm, this.pe);
        this.frm_rf.setSize(1024, 600);
        this.frm_rf.setLocationRelativeTo(null);
        System.out.println("Gui inited!");
    }

    private void setEnvTable(DefaultTableModel dtm, EnvironmentEntry[] mee) {
        for (int i = 0; i < mee.length; ++i) {
            dtm.addRow(new Object[]{mee[i].theKey, mee[i].theValue});
        }
    }

    private void setResizeOn(JTable jt) {
        jt.getTableHeader().setResizingAllowed(true);
        jt.setPreferredScrollableViewportSize(new Dimension(900, 70));
    }
}

