/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.receiver;

import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.Activator;
import com.sun.corba.se.spi.activation.ActivatorHelper;
import com.sun.corba.se.spi.activation.BadServerDefinition;
import com.sun.corba.se.spi.activation.Repository;
import com.sun.corba.se.spi.activation.RepositoryHelper;
import com.sun.corba.se.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.se.spi.activation.ServerAlreadyActive;
import com.sun.corba.se.spi.activation.ServerAlreadyRegistered;
import com.sun.corba.se.spi.activation.ServerHeldDown;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import org.jchains.CORBA.PermissionTransfer;
import org.jchains.CORBA.PermissionTransferHelper;
import org.jchains.CORBA.PermissionTransferPackage.EnvironmentEntry;
import org.jchains.receiver.FileReceiverStrategy;
import org.jchains.receiver.PermissionTransferServant;
import org.jchains.receiver.ReceiverStrategy;
import org.jchains.receiver.SocketServer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class Receiver {
    static final Logger log = Logger.getLogger("JChains");
    static String applicationName = "PermissionTransfer";
    static String classpath = new File("ia.zip").getAbsolutePath();
    static String name = Receiver.class.getName();
    static String vmargs = "-Xmx512M";
    static String progargs = "";

    public static void main(String[] args) {
        ReceiverStrategy rs = null;
        System.out.println("*");
        System.out.println(applicationName);
        System.out.println(classpath);
        System.out.println(name);
        System.out.println(vmargs);
        System.out.println(progargs);
        if (args.length > 0) {
            if (args[0].equals("-register")) {
                Receiver.doRegister(args);
            } else if (args[0].equals("-unregister")) {
                Receiver.doUnRegister(args);
            } else if (args[0].equals("-test")) {
                Receiver.doTest(args);
            } else if (args[0].equals("-test2")) {
                Receiver.doTest2(args);
            } else if (args[0].equals("-simplesocket")) {
                Receiver.doSocketServerStart(args);
            } else if (args[0].equals("-file")) {
                rs = new FileReceiverStrategy();
            }
        }
        if (rs != null) {
            rs.init(args);
        }
    }

    private static void doSocketServerStart(String[] args) {
        PermissionTransferServant pts = new PermissionTransferServant(null);
        pts.init("hudel", new EnvironmentEntry[0]);
        Receiver r = new Receiver();
        SocketServer sserv = new SocketServer(pts, r, 14444);
        sserv.start();
    }

    private static void doTest2(String[] args) {
        try {
            Properties properties = System.getProperties();
            properties.put("org.omg.CORBA.ORBInitialHost", "localhost");
            properties.put("org.omg.CORBA.ORBInitialPort", "1050");
            ORB orb = ORB.init((String[])args, (Properties)properties);
            Object obj = orb.resolve_initial_references("NameService");
            NamingContextExt rootContext = NamingContextExtHelper.narrow((Object)obj);
            BindingListHolder bl = new BindingListHolder();
            BindingIteratorHolder bi = new BindingIteratorHolder();
            rootContext.list(10, bl, bi);
            System.out.println(bl.value[0].binding_name);
            NameComponent[] nc = rootContext.to_name("PermissionTransfer");
            Object obj1 = rootContext.resolve_str("PermissionTransfer");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static void doTest(String[] args) {
        try {
            String s = System.getProperty("org.jchains.CNameServiceIOR", "corbaloc::127.0.0.1:1050/NameService");
            String fn = System.getProperty("org.jchains.outputfile", System.currentTimeMillis() + "out.txt");
            System.out.println(s);
            ORB orb = ORB.init((String[])new String[0], null);
            Object obj = orb.string_to_object(s);
            NamingContextExt namingcontextext = NamingContextExtHelper.narrow((Object)obj);
            System.out.println("nc0:" + namingcontextext);
            Object obj1 = namingcontextext.resolve_str("PermissionTransfer");
            PermissionTransfer pt = PermissionTransferHelper.narrow(obj1);
            System.out.println("pt:" + pt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static void doRegister(String[] args) {
        String[] newargs = Receiver.newargs(args);
        int serverId = 0;
        try {
            Properties props = System.getProperties();
            props.put("org.omg.CORBA.ORBClass", "com.sun.corba.se.impl.orb.ORBImpl");
            props.put("org.omg.CORBA.ORBInitialHost", "localhost");
            props.put("org.omg.CORBA.ORBInitialPort", "1050");
            ORB orb = ORB.init((String[])newargs, (Properties)props);
            Repository repository = RepositoryHelper.narrow((Object)orb.resolve_initial_references("ServerRepository"));
            ServerDef server = new ServerDef(applicationName, name, classpath, progargs, vmargs);
            serverId = repository.registerServer(server);
            Activator activator = ActivatorHelper.narrow((Object)orb.resolve_initial_references("ServerActivator"));
            activator.activate(serverId);
            activator.install(serverId);
            System.out.println(CorbaResourceUtil.getText((String)"servertool.register2", (int)serverId));
        }
        catch (ServerNotRegistered ex) {
        }
        catch (ServerAlreadyActive ex) {
        }
        catch (ServerHeldDown ex) {
            System.out.println(CorbaResourceUtil.getText((String)"servertool.register3", (int)serverId));
        }
        catch (ServerAlreadyRegistered ex) {
            System.out.println(CorbaResourceUtil.getText((String)"servertool.register4", (int)serverId));
        }
        catch (BadServerDefinition ex) {
            System.out.println(CorbaResourceUtil.getText((String)"servertool.baddef", (String)ex.reason));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    private static String[] newargs(String[] args) {
        java.lang.Object[] newargs = new String[args.length - 1];
        System.arraycopy(args, 1, newargs, 0, newargs.length);
        String s1 = Arrays.toString(newargs);
        String s2 = Arrays.toString(args);
        System.out.println(s1 + ":" + s2);
        return newargs;
    }

    static int getServerIdForAlias(ORB orb, String applicationName) throws ServerNotRegistered {
        try {
            Repository rep = RepositoryHelper.narrow((Object)orb.resolve_initial_references("ServerRepository"));
            int serverid = rep.getServerID(applicationName);
            return rep.getServerID(applicationName);
        }
        catch (Exception ex) {
            throw new ServerNotRegistered();
        }
    }

    private static void doUnRegister(String[] args) {
        String[] newargs = Receiver.newargs(args);
        try {
            Properties props = System.getProperties();
            props.put("org.omg.CORBA.ORBClass", "com.sun.corba.se.impl.orb.ORBImpl");
            props.put("org.omg.CORBA.ORBInitialHost", "localhost");
            props.put("org.omg.CORBA.ORBInitialPort", "1050");
            ORB orb = ORB.init((String[])newargs, (Properties)props);
            int serverId = Receiver.getServerIdForAlias(orb, applicationName);
            try {
                Activator activator = ActivatorHelper.narrow((Object)orb.resolve_initial_references("ServerActivator"));
                activator.uninstall(serverId);
            }
            catch (ServerHeldDown ex) {
                // empty catch block
            }
            Repository repository = RepositoryHelper.narrow((Object)orb.resolve_initial_references("ServerRepository"));
            repository.unregisterServer(serverId);
            System.out.println(CorbaResourceUtil.getText((String)"servertool.unregister2"));
        }
        catch (ServerNotRegistered ex) {
            System.out.println(CorbaResourceUtil.getText((String)"servertool.nosuchserver"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }
}

