/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.receiver;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jchains.CORBA.PermissionTransferPackage.EnvironmentEntry;
import org.jchains.receiver.Perm;

public class PolicyFile {
    static final Logger log = Logger.getLogger("JChains");
    private String m_filename;
    Hashtable<String, Hashtable<String, Hashtable<String, Perm>>> ht_codebase = new Hashtable();
    Hashtable<String, Boolean> permhandledcache = new Hashtable();
    EnvironmentEntry[] m_ee = new EnvironmentEntry[0];
    static final String linesep = System.getProperty("line.separator");

    public PolicyFile(String fn, EnvironmentEntry[] ee) {
        this.m_filename = fn;
        this.m_ee = ee;
    }

    public boolean add(Perm p) {
        Hashtable<String, Perm> ve_vect;
        String z = p.getMD5();
        if (this.permhandledcache.containsKey(z)) {
            return false;
        }
        this.permhandledcache.put(z, Boolean.TRUE);
        Hashtable<String, Hashtable<String, Perm>> ht_perm = this.ht_codebase.get(p.codebase);
        if (ht_perm == null) {
            ht_perm = new Hashtable();
            this.ht_codebase.put(p.codebase, ht_perm);
        }
        if ((ve_vect = ht_perm.get(p.pname)) == null) {
            ve_vect = new Hashtable();
            ht_perm.put(p.pname, ve_vect);
        }
        ve_vect.put(p.getMD5(), p);
        return true;
    }

    synchronized void toXML() {
        try {
            XMLEncoder xe = new XMLEncoder(new FileOutputStream(this.m_filename + "xml"));
            xe.writeObject(this);
            xe.close();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public PolicyFile(String filename) throws IOException {
        XMLDecoder xd = new XMLDecoder(new FileInputStream(filename));
        PolicyFile f = (PolicyFile)xd.readObject();
        this.ht_codebase = f.ht_codebase;
        this.m_filename = f.m_filename;
        this.m_ee = f.m_ee;
        xd.close();
    }

    void save() {
        try {
            log.info("saving");
            FileOutputStream fos = new FileOutputStream(this.m_filename);
            log.info("saving0");
            PrintWriter pw = new PrintWriter(fos, true);
            log.info("saving2");
            pw.print(this.getContent(true));
            log.info("saving3");
            pw.close();
            log.info("saving4");
            fos.close();
        }
        catch (IOException e) {
            log.warning("Unable to save!" + e);
        }
        catch (ClassCastException e) {
            log.warning("Unable to save!" + e);
            e.printStackTrace();
        }
        catch (Exception e) {
            log.warning("Some exception occured :" + e.toString());
            log.warning(e.getMessage());
            log.log(Level.WARNING, "", e);
        }
    }

    public String getContent(boolean t) {
        StringBuffer sb = new StringBuffer(10000);
        log.info("before");
        Enumeration<String> e = this.ht_codebase.keys();
        while (e.hasMoreElements()) {
            String codebase = e.nextElement();
            log.info(codebase);
            sb.append("grant ");
            if (codebase.length() > 0) {
                sb.append(" Codebase ").append('\"').append(codebase).append('\"');
            }
            sb.append(' ').append('{').append(linesep);
            Hashtable<String, Hashtable<String, Perm>> ht_perm = this.ht_codebase.get(codebase);
            Enumeration<String> f = ht_perm.keys();
            while (f.hasMoreElements()) {
                String thePerm = f.nextElement();
                Hashtable<String, Perm> thePerms = ht_perm.get(thePerm);
                Enumeration<Perm> g = thePerms.elements();
                while (g.hasMoreElements()) {
                    Perm p = g.nextElement();
                    sb.append(p.getPermissionLine(true));
                }
            }
            sb.append("};").append(linesep);
        }
        return sb.toString();
    }
}

