/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.receiver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jchains.CORBA.PermissionTransferPOA;
import org.jchains.CORBA.PermissionTransferPackage.CPermission;
import org.jchains.CORBA.PermissionTransferPackage.EnvironmentEntry;
import org.jchains.internal.Util;
import org.jchains.receiver.Perm;
import org.jchains.receiver.PolicyFile;
import org.jchains.receiver.gui.GUIManagement;
import org.jchains.receiver.gui.ReceiverForm;
import org.omg.CORBA.ORB;

public class PermissionTransferServant
extends PermissionTransferPOA {
    static final String filesep = System.getProperty("file.separator");
    static String javatmpdirprefix = System.getProperty("java.io.tmpdir");
    static final Logger log = Logger.getLogger("JChains");
    public static final int RECORDING_MODE_INTERACTIVE = 2;
    public static final int RECORDING_MODE_SILENT = 1;
    static String savedirprefix = System.getProperty("org.jchains.SaveDirPrefix", javatmpdirprefix);
    int anzahl = 0;
    private EnvironmentEntry[] ee = new EnvironmentEntry[0];
    private Vector<Perm> perms = new Vector();
    private ORB orb;
    PolicyFile pf = null;
    boolean pref_GUI = true;
    private PrintWriter pw_log;
    int recordingmode = 2;
    GUIManagement gp;
    private String savefilename;
    private String envfilename;
    private String policyfilename;
    boolean b_tofile = false;

    public PermissionTransferServant(ORB orb) {
        this.orb = orb;
        this.recordingmode = 2;
        this.pref_GUI = !Boolean.getBoolean("org.jchains.noGUI");
        System.out.println(orb == null ? "" : orb.toString());
    }

    public PermissionTransferServant() {
        this.recordingmode = 2;
        this.pref_GUI = !Boolean.getBoolean("org.jchains.noGUI");
        System.out.println(this.orb == null ? "" : this.orb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int sid) {
        try {
            this.pf.save();
            if (this.pref_GUI) {
                ReceiverForm fr = this.gp.getReceiverForm();
                fr.getFieldTxtMode().setText("finished");
                fr.getFieldTxtPolicyFile().setText(this.pf.getContent(true));
            }
            this.pw_log.close();
        }
        catch (Exception e) {
            log.info(e.getMessage());
            log.log(Level.WARNING, "", e);
        }
    }

    private PrintWriter getIncrementalFile(String filename, int incname) {
        FileOutputStream fosret = null;
        PrintWriter pw = null;
        File f = new File(filename);
        boolean end = false;
        int i = 0;
        while (end) {
            if (!f.exists()) {
                end = true;
            } else {
                f = new File(filename + incname);
                ++incname;
            }
            ++i;
        }
        try {
            fosret = new FileOutputStream(f);
            pw = new PrintWriter(fosret, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pw;
    }

    @Override
    public int init(String filename, EnvironmentEntry[] pe) {
        this.anzahl = 0;
        try {
            if (this.pref_GUI) {
                this.gp = new GUIManagement();
                this.gp.initGUI(pe);
                log.info("init gui!");
            } else {
                log.info("no gui!");
            }
            this.savefilename = savedirprefix + filesep + Util.tidyFilename(filename);
            this.policyfilename = this.savefilename + ".policy";
            this.envfilename = this.savefilename + ".env";
            int incname = 1;
            this.pw_log = this.getIncrementalFile(this.savefilename, incname);
            this.pf = new PolicyFile(this.policyfilename, pe);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(int sid, CPermission p) {
        if (p.cn.startsWith("sun.")) {
            return;
        }
        if (p.cn.startsWith("java.")) {
            return;
        }
        if (p.cn.startsWith("javax.")) {
            return;
        }
        long theTime = System.currentTimeMillis();
        Perm pe = new Perm(theTime, p, this.ee);
        boolean isnew = this.pf.add(pe);
        if (!isnew) {
            return;
        }
        this.perms.add(pe);
        try {
            ++this.anzahl;
            if (this.recordingmode == 1) return;
            if (this.b_tofile) {
                this.pw_log.print(p.pt);
                this.pw_log.print(' ');
                this.pw_log.print(p.cb);
                this.pw_log.print(' ');
                this.pw_log.print(p.target);
                this.pw_log.print(' ');
            }
            if (this.anzahl % 50 != 0) return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        catch (Throwable t) {
            log.info(t.getClass().toString());
            log.log(Level.ALL, "unknown", t);
        }
    }

    static {
        log.info("using savedir: " + savedirprefix);
    }
}

