/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.receiver;

import java.io.Serializable;
import java.security.MessageDigest;
import java.util.logging.Logger;
import org.jchains.CORBA.PermissionTransferPackage.CPermission;
import org.jchains.CORBA.PermissionTransferPackage.EnvironmentEntry;
import org.jchains.CORBA.PermissionTransferPackage.Stacktrace;
import org.jchains.internal.Util;
import org.jchains.receiver.gui.PermTableModel;

public class Perm
implements Serializable {
    private static final long serialVersionUID = 4711L;
    static final Logger log = Logger.getLogger("JChains");
    static final String linesep = System.getProperty("line.separator");
    long time = 0L;
    String codebase = "";
    String pname = "";
    String target = "";
    String classname = "";
    String[] actions = null;
    int number = -1;
    String filename;
    String methodname;
    int linenum;
    EnvironmentEntry[] m_ee = new EnvironmentEntry[0];
    String md5 = "";
    static String compstr = new String(new byte[]{34});

    public Perm() {
    }

    public Perm(long _time, CPermission p, EnvironmentEntry[] ee) {
        this.time = _time;
        this.classname = p.cn.intern();
        this.codebase = p.cb.intern();
        this.pname = p.pt.intern();
        this.target = p.target.intern();
        this.actions = p.actions;
        this.m_ee = ee;
        Stacktrace current = this.getFittingStackTraceString(p.stack);
        this.filename = current.filename;
        this.methodname = current.methodname;
        this.linenum = current.linenumber;
    }

    private void normalizeName() {
        this.target = this.target.replace('\\', '/');
        if (this.target.indexOf(34) == -1) {
            return;
        }
        StringBuffer sb = new StringBuffer(this.target);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\"') continue;
            sb.insert(i, '\\');
            ++i;
        }
        this.target = sb.toString();
        log.info(this.target);
    }

    private Stacktrace getFittingStackTraceString(Stacktrace[] stacktrace) {
        Stacktrace current = null;
        int stackpos = -1;
        for (int i = 0; i < stacktrace.length; ++i) {
            if (!stacktrace[i].classname.equals(this.classname)) continue;
            stackpos = i;
            break;
        }
        current = stacktrace[stackpos];
        current.classname = "";
        current.methodname = current.methodname.intern();
        current.filename = current.filename.intern();
        stacktrace = null;
        return current;
    }

    private static String concat(char del, String[] arr) {
        if (arr.length == 0) {
            return "";
        }
        StringBuffer b = new StringBuffer(100);
        for (int i = 0; i < arr.length; ++i) {
            b.append(arr[i]);
            b.append(del);
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    public String getFlatActions() {
        return Perm.concat(',', this.actions);
    }

    public String getMD5() {
        if (this.md5 == null || this.md5.equals("")) {
            String tmp = this.pname + this.target + this.getFlatActions();
            this.md5 = Util.getMD5forString(tmp);
        }
        return this.md5;
    }

    private String doReplace(String text) {
        for (int i = 0; i < this.m_ee.length; ++i) {
            int idx = text.indexOf(this.m_ee[i].theValue);
            String val = this.m_ee[i].theValue.trim();
            int replen = val.length();
            if (idx < 0 || replen <= 7) continue;
            text = text.substring(0, idx) + "${" + this.m_ee[i].theKey + "}" + text.substring(idx + replen);
        }
        return text;
    }

    public String getPermissionLine(boolean b) {
        if (b) {
            this.target = this.doReplace(this.target);
        }
        this.target = this.target.replaceAll("\"", "\\\\\"");
        StringBuffer sb = new StringBuffer(300);
        sb.append("permission ").append(this.pname).append(' ').append('\"').append(this.target).append('\"').append(' ');
        String actflat = this.getFlatActions();
        if (actflat.length() > 0) {
            sb.append(',').append('\"').append(actflat).append('\"');
        }
        sb.append(';');
        sb.append("  //").append(this.classname);
        sb.append(",").append(this.methodname);
        sb.append(":").append(this.linenum);
        sb.append(linesep);
        return sb.toString();
    }

    public static String getLinesep() {
        return linesep;
    }

    public static Logger getLog() {
        return log;
    }

    public static MessageDigest getMd() {
        return Util.md;
    }

    public String getAction() {
        return this.getFlatActions();
    }

    public String getCodebase() {
        return this.codebase;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getMethodname() {
        return this.methodname;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setClassname(String _classname) {
        this.classname = _classname;
    }

    public String getTarget() {
        return this.target;
    }

    public String getPname() {
        return this.pname;
    }

    public void setCodebase(String string) {
        this.codebase = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setPname(String string) {
        this.pname = string;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String[] getActions() {
        return this.actions;
    }

    public void setActions(String[] actions) {
        this.actions = actions;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getXML() {
        return "<Permission><Codebase>" + this.getCodebase() + "</Codebase>" + "<Class>" + this.getClassname() + "<Class>" + "<Time>" + this.getTime() + "</Time>" + "<Filename>" + this.getFilename() + "</Filename>" + "<Pname>" + this.getPname() + "</Pname>" + "<Target>" + this.getTarget() + "</Target>" + "<Actions>" + this.getFlatActions() + "</Actions>" + "<LineNumber>" + this.getNumber() + "</LineNumber>";
    }

    public String toString() {
        String ename = Util.shortcutEncode(this.target);
        return this.getTime() + ";" + this.getCodebase() + ";" + this.pname + ";" + ename + ";" + this.getAction() + ";" + this.getMethodname() + ";" + this.getClassname() + ";" + this.getNumber();
    }

    public Perm(String zeugStrings) {
        String ename;
        System.out.println(zeugStrings);
        String[] z = zeugStrings.split(";");
        int i = 0;
        this.time = Long.parseLong(z[i++]);
        this.codebase = z[i++];
        this.pname = z[i++];
        this.target = ename = Util.shortDecode(z[i++]);
        this.actions = z[i++].split(",");
        this.methodname = z[i++];
        this.classname = z[i++];
        this.linenum = Integer.parseInt(z[i++]);
    }

    public Object[] getRowObject() {
        return new Object[]{PermTableModel.getShortTimeFromLong(this.getTime()), this.getCodebase(), this.getPname(), this.getTarget(), this.getFlatActions(), this.getClassname(), this.getMethodname(), this.getNumber()};
    }
}

