/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.internal;

import java.awt.Component;
import java.awt.Container;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import org.jchains.CORBA.PermissionTransferPackage.EnvironmentEntry;
import org.jchains.CORBA.PermissionTransferPackage.Stacktrace;
import org.jchains.CORBA.PermissionTransferPackage.StacktraceSeqHolder;

public class Util {
    public static final EnvironmentEntry[] emptyret = new EnvironmentEntry[0];
    public static MessageDigest md = null;

    public static String tidyFilename(String theName) {
        theName = theName.replace(':', '_');
        theName = theName.replace('/', '_');
        theName = theName.replace('\\', '_');
        return theName;
    }

    public static EnvironmentEntry[] propsToEnvironmentEntry(Properties p) {
        EnvironmentEntry[] ret = emptyret;
        if (p.size() == 0) {
            return ret;
        }
        ret = new EnvironmentEntry[p.size()];
        int i = 0;
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            EnvironmentEntry ee = new EnvironmentEntry();
            ee.theKey = (String)e.nextElement();
            ee.theValue = p.getProperty(ee.theKey);
            ret[i++] = ee;
        }
        return ret;
    }

    public static void waitMillis(int wait) {
        try {
            Thread.sleep(wait);
        }
        catch (Exception e) {
            System.out.println("Get another JDK, this is b0rken");
            System.exit(-1);
        }
    }

    public static StacktraceSeqHolder Ste2String(StackTraceElement[] ste) {
        Stacktrace[] arr = new Stacktrace[ste.length];
        for (int i = 0; i < ste.length; ++i) {
            arr[i] = new Stacktrace();
            arr[i].classname = Util.NullHelper(ste[i].getClassName());
            arr[i].filename = Util.NullHelper(ste[i].getFileName());
            arr[i].methodname = Util.NullHelper(ste[i].getMethodName());
            arr[i].isnative = ste[i].isNativeMethod();
            arr[i].linenumber = (short)ste[i].getLineNumber();
        }
        return new StacktraceSeqHolder(arr);
    }

    public static String ste2sum(StackTraceElement[] ste, int position) {
        String str = "";
        int i = position;
        str = str + Util.NullHelper(ste[i].getClassName());
        str = str + Util.NullHelper(ste[i].getFileName());
        str = str + Util.NullHelper(ste[i].getMethodName());
        str = str + ste[i].isNativeMethod();
        str = str + (short)ste[i].getLineNumber();
        return str;
    }

    public static String ste2sum(StackTraceElement[] ste) {
        String str = "";
        for (int i = 0; i < ste.length; ++i) {
            str = str + Util.NullHelper(ste[i].getClassName());
            str = str + Util.NullHelper(ste[i].getFileName());
            str = str + Util.NullHelper(ste[i].getMethodName());
            str = str + ste[i].isNativeMethod();
            str = str + (short)ste[i].getLineNumber();
        }
        return str;
    }

    public StacktraceSeqHolder Ste2String(StackTraceElement[] ste, int position) {
        Stacktrace[] arr = new Stacktrace[]{new Stacktrace()};
        arr[0].classname = Util.NullHelper(ste[position].getClassName());
        arr[0].filename = Util.NullHelper(ste[position].getFileName());
        arr[0].methodname = Util.NullHelper(ste[position].getMethodName());
        arr[0].isnative = ste[position].isNativeMethod();
        arr[0].linenumber = (short)ste[position].getLineNumber();
        return new StacktraceSeqHolder(arr);
    }

    public static String shortDecode(String name) {
        String ename = "";
        try {
            ename = URLDecoder.decode(name, "UTF-8");
        }
        catch (Exception e) {
            System.err.println("Don't use this JDK, it's b0rken");
            System.exit(-1);
        }
        return ename;
    }

    public static String shortcutEncode(String z) {
        String ename = "";
        try {
            ename = URLEncoder.encode(z, "UTF-8");
        }
        catch (Exception e) {
            System.out.println("Don't use this JDK, it's b0rken");
            System.exit(-1);
        }
        return ename;
    }

    public static String NullHelper(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static synchronized String getMD5forString(String tmp) {
        MessageDigest digest = md;
        if (tmp == null || tmp == "") {
            tmp = "<empty>";
        }
        digest.reset();
        digest.update(tmp.getBytes());
        byte[] hash = digest.digest();
        String dig = new String(hash);
        return dig;
    }

    public static void printSizes(Component c) {
        System.out.println("minimumSize = " + c.getMinimumSize());
        System.out.println("preferredSize = " + c.getPreferredSize());
        System.out.println("maximumSize = " + c.getMaximumSize());
    }

    public static void makeGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout.Constraints cons;
        int i;
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeGrid must use SpringLayout.");
            return;
        }
        Spring xPadSpring = Spring.constant(xPad);
        Spring yPadSpring = Spring.constant(yPad);
        Spring initialXSpring = Spring.constant(initialX);
        Spring initialYSpring = Spring.constant(initialY);
        int max = rows * cols;
        Spring maxWidthSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        Spring maxHeightSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        for (i = 1; i < max; ++i) {
            cons = layout.getConstraints(parent.getComponent(i));
            maxWidthSpring = Spring.max(maxWidthSpring, cons.getWidth());
            maxHeightSpring = Spring.max(maxHeightSpring, cons.getHeight());
        }
        for (i = 0; i < max; ++i) {
            cons = layout.getConstraints(parent.getComponent(i));
            cons.setWidth(maxWidthSpring);
            cons.setHeight(maxHeightSpring);
        }
        SpringLayout.Constraints lastCons = null;
        SpringLayout.Constraints lastRowCons = null;
        for (int i2 = 0; i2 < max; ++i2) {
            SpringLayout.Constraints cons2 = layout.getConstraints(parent.getComponent(i2));
            if (i2 % cols == 0) {
                lastRowCons = lastCons;
                cons2.setX(initialXSpring);
            } else {
                cons2.setX(Spring.sum(lastCons.getConstraint("East"), xPadSpring));
            }
            if (i2 / cols == 0) {
                cons2.setY(initialYSpring);
            } else {
                cons2.setY(Spring.sum(lastRowCons.getConstraint("South"), yPadSpring));
            }
            lastCons = cons2;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", Spring.sum(Spring.constant(yPad), lastCons.getConstraint("South")));
        pCons.setConstraint("East", Spring.sum(Spring.constant(xPad), lastCons.getConstraint("East")));
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, Util.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = Util.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, Util.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = Util.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    static {
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

