/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.intercept;

import java.io.FilePermission;
import java.security.Permission;
import java.util.logging.Logger;
import org.jchains.CORBA.PermissionTransfer;
import org.jchains.CORBA.PermissionTransferPackage.CPermission;
import org.jchains.CORBA.PermissionTransferPackage.EnvironmentEntry;
import org.jchains.CORBA.PermissionTransferPackage.StacktraceSeqHolder;
import org.jchains.intercept.CORBAStrategy;
import org.jchains.intercept.CodeSourceForClass;
import org.jchains.intercept.Emitter;
import org.jchains.intercept.FileStrategy;
import org.jchains.intercept.PermissionCache;
import org.jchains.intercept.SocketStrategy;
import org.jchains.intercept.Strategy;
import org.jchains.internal.Util;

public class StandardEmitter
implements Emitter {
    static final Logger log = Logger.getLogger("JChains");
    PermissionTransfer pt;
    PermissionCache pc = new PermissionCache();
    CodeSourceForClass csc = new CodeSourceForClass();
    EnvironmentEntry[] eearr = Util.propsToEnvironmentEntry(System.getProperties());
    String bomitFilePermissions = System.getProperty("org.jchains.suppressFilePermissions", "classfiles");
    Strategy strat;
    static boolean bLogIt = false;

    public StandardEmitter() {
        this('F');
    }

    @Override
    public void exit() {
        this.strat.end();
    }

    public StandardEmitter(char e) {
        switch (e) {
            case 'F': {
                this.strat = new FileStrategy();
                break;
            }
            case 'O': {
                this.strat = new CORBAStrategy();
                break;
            }
            case 'S': {
                this.strat = new SocketStrategy();
                break;
            }
            default: {
                this.strat = new FileStrategy();
            }
        }
    }

    @Override
    public void init() throws Exception {
        this.strat.init();
    }

    @Override
    public void emit(Class c, Permission permission, StackTraceElement[] ste) {
        String cname = c.getName();
        String target = permission.getName();
        if (cname.startsWith("sun.")) {
            return;
        }
        if (cname.startsWith("java.")) {
            return;
        }
        if (cname.startsWith("javax.")) {
            return;
        }
        if (permission instanceof FilePermission) {
            if (this.bomitFilePermissions.equals("all")) {
                return;
            }
            if (this.bomitFilePermissions.equals("classfiles") && target.endsWith(".class")) {
                return;
            }
        }
        String cs_str = this.csc.put(c);
        String theperm = permission.getClass().getName();
        String compstr = theperm + cs_str + target + permission.getActions();
        if (!this.pc.containsKey(compstr)) {
            this.pc.put(compstr, "1");
            String[] actions = permission.getActions().split(",");
            if (bLogIt) {
                log.info("AL:" + actions.length + ":" + permission.getActions());
            }
            StacktraceSeqHolder stack = Util.Ste2String(ste);
            CPermission p = new CPermission(cname, theperm, cs_str, target, actions, 0, stack.value);
            this.strat.send(p);
            p = null;
        }
    }
}

