/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.intercept;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.jchains.intercept.Emitter;
import org.jchains.intercept.TextEmitter;

public class JChainsSecInterceptor
extends SecurityManager {
    private static final String str_CommonPackagePrefix = "org.jchains";
    private static final String emitterprefix = "org.jchains.intercept.";
    private static final String str_emitClassName = "org.jchains.emitClass";
    private static boolean alwaysemit = Boolean.getBoolean("org.jchains.always");
    ThreadGroup tg = new ThreadGroup("jchains");
    static Emitter emit;
    static final Logger log;
    ProtectionDomain pd_default = String.class.getProtectionDomain();
    PermissionCollection pc_default = this.pd_default.getPermissions();
    CachedPDCheck cpc = new CachedPDCheck();

    public JChainsSecInterceptor() {
        System.out.println("add JChainsSecInterceptor ShutdownHook");
        Runtime.getRuntime().addShutdownHook(new InterceptorShutdown());
    }

    @Override
    public void checkPermission(Permission permission) {
        boolean cache = true;
        Class[] aclass = this.getClassContext();
        int i = 0;
        for (int j = 0; j < aclass.length; ++j) {
            if (!aclass[j].getName().startsWith(str_CommonPackagePrefix) || ++i <= 1) continue;
            return;
        }
        SecurityException theException = null;
        boolean allowed = true;
        if (!alwaysemit) {
            try {
                super.checkPermission(permission);
            }
            catch (SecurityException sp) {
                allowed = false;
                theException = sp;
            }
        }
        if (!allowed || alwaysemit) {
            theException = theException == null ? new SecurityException() : theException;
            StackTraceElement[] astacktraceelement = theException.getStackTrace();
            this.logit(aclass, astacktraceelement, permission, null);
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        log.info("xxx123xxx:" + target);
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.tg;
    }

    @Override
    public void checkPermission(Permission permission, Object obj) {
        log.info("mit OBject:" + obj);
        boolean allowed = true;
        try {
            super.checkPermission(permission, obj);
        }
        catch (SecurityException sp) {
            allowed = false;
        }
        if (!allowed || alwaysemit) {
            Class[] aclass = this.getClassContext();
            int i = 0;
            for (int j = 0; j < aclass.length; ++j) {
                if (!aclass[j].getName().startsWith(str_CommonPackagePrefix) || ++i <= 1) continue;
                return;
            }
            StackTraceElement[] astacktraceelement = new Throwable().getStackTrace();
            this.logit(aclass, astacktraceelement, permission, obj);
        }
    }

    private void logit(Class[] classes, StackTraceElement[] ste, Permission permission, Object obj) {
        for (int i = 0; i < classes.length; ++i) {
            Boolean ret;
            Class class1 = classes[i];
            String sname = class1.getName();
            if (sname.startsWith(str_CommonPackagePrefix) || sname.startsWith("sun.") || sname.startsWith("java.") || sname.startsWith("javax.") || !(ret = this.cpc.putClass(class1)).booleanValue()) continue;
            emit.emit(class1, permission, ste);
        }
    }

    private CodeSource getCodeSourceForClass(Class class1) {
        CodeSource codesource = null;
        ProtectionDomain protectiondomain = class1.getProtectionDomain();
        if (protectiondomain != null) {
            codesource = protectiondomain.getCodeSource();
        }
        return codesource;
    }

    protected void finalize() {
        emit.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        log = Logger.getLogger("JChains");
        System.out.println("choosing emitter");
        emit = new TextEmitter();
        String s = emitterprefix + System.getProperty(str_emitClassName, "StandardEmitter");
        try {
            if (s != null && s.length() > 0) {
                emit = (Emitter)Class.forName(s).newInstance();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                emit.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println(emit + " inited");
    }

    class InterceptorShutdown
    extends Thread {
        int sid;

        InterceptorShutdown() {
        }

        @Override
        public void run() {
            System.out.println("JChainsSecInterceptor ShutdownHook called");
            emit.exit();
        }
    }

    class CachedPDCheck
    extends Hashtable<Class, Boolean> {
        CachedPDCheck() {
        }

        public synchronized Boolean putClass(Class key) {
            Boolean ret;
            CodeSource cs = null;
            if (!this.containsKey(key)) {
                cs = JChainsSecInterceptor.this.getCodeSourceForClass(key);
                ret = cs != null;
                super.put(key, ret);
            } else {
                ret = (Boolean)this.get(key);
            }
            return ret;
        }
    }

    class OrderedProtectionDomain {
        short m_number;
        ProtectionDomain m_pd;

        OrderedProtectionDomain(short i, ProtectionDomain pd) {
            this.m_number = i;
            this.m_pd = pd;
        }
    }
}

