/*
 * Decompiled with CFR 0.152.
 */
package org.jchains.intercept;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.jchains.CORBA.PermissionTransferPackage.CPermission;
import org.jchains.intercept.Strategy;
import org.jchains.internal.Util;
import org.jchains.receiver.Perm;

class FileStrategy
extends Strategy {
    FileChannel destination;
    File destFile = new File(System.getProperty("org.jchains.file", "permissions.csv"));
    ObjectOutputStream oos;
    BufferedWriter bw;

    FileStrategy() {
    }

    @Override
    public void init() throws Exception {
        if (!this.destFile.exists()) {
            this.destFile.createNewFile();
        }
        this.destination = new FileOutputStream(this.destFile).getChannel();
        this.bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.destFile)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(CPermission cp) {
        try {
            Perm perm = new Perm(System.currentTimeMillis(), cp, Util.emptyret);
            try {
                BufferedWriter bufferedWriter = this.bw;
                synchronized (bufferedWriter) {
                    this.bw.write(perm.toString() + "\r\n");
                    this.bw.flush();
                }
            }
            catch (ClosedChannelException e) {
                System.out.println("NIO channel is closed, this is expected during shutdown");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    void end() {
        try {
            this.bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

