package org.jchains.receiver.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ReceiverForm extends JDialog implements ActionListener,ClipboardOwner  {

	static boolean DEBUG = Boolean.parseBoolean(System.getProperty(
			"org.jchains.debug", "false"));
	private static final long serialVersionUID = 1L;

	static ReceiverForm theReceiverForm;

	JPanel pnPanel0;

	JPanel pnPanel1;
	JTabbedPane tbpPanel0;

	JPanel pnPanel2;
	JLabel lbLabel4;
	JTextField tfTxtDate;
	JLabel lbLabel0;
	JTextField tfTxtTime;
	JLabel lbLabel8;
	JTextField tfTxtMode;

	JPanel pnPanel6;
	JLabel lbLabel15;
	JLabel lbLabel19;
	JLabel lbLabel22;
	JTextField tfPermType;
	JTextField tfPermTarget;
	JTextField tfPermActions;
	JLabel lbLabel24;
	JTextField tfPermTime;
	JLabel lbLabel26;
	JTextField tfPermCodebase;
	JTextField tfPermClass;
	JLabel lbLabel37;
	JTextField tfPermMethod;
	JLabel lbLabel39;
	JLabel lbLabel28;
	JTextField tfTxtLog;
	JLabel lbLabel30;
	JTextField tfTxtPolicy;
	JScrollPane scpPermissions;

	JPanel pnPermissions;
	PermissionsTable tbPermissions;

	JPanel pnPanel4;
	JTable tbEnvironment;

	JPanel pnPanel5;
	JTextArea taTxtPolicyFile;

	JPanel pnPanel15;
	JButton btBtnSave;
	JTextField tfTxtFilename;

	JPanel pnPanel16;
	JButton btBntOptimize;

	JPanel pnPanel14;
	JTextArea taTxtAboutaa;

	/**
 */
/*	public static void main(String args[]) {
		try {
			UIManager.setLookAndFeel(UIManager
					.getCrossPlatformLookAndFeelClassName());
		} catch (ClassNotFoundException e) {
		} catch (InstantiationException e) {
		} catch (IllegalAccessException e) {
		} catch (UnsupportedLookAndFeelException e) {
		}
		theReceiverForm = new ReceiverForm();
	}*/

	/**
 */
	public JTextArea getTxtAbout() {
		return taTxtAboutaa;
	}

	public JTable getTabEnvironment() {
		return tbEnvironment;
	}

	public void setTabEnvironment(JTable t) {
		tbEnvironment = t;
	}

	public JTable getTabPermission() {
		return tbPermissions;
	}

	public JTextField getFieldTxtMode() {
		return tfTxtMode;
	}

	public JTextArea getFieldTxtPolicyFile() {
		return taTxtPolicyFile;

	}

	public JTextField getFieldTxtLog() {
		return tfTxtLog;
	}

	public JTextField getFieldTxtTime() {
		return tfTxtTime;
	}

	public ReceiverForm() {
		super();
		// super( OWNER, "TITLE", MODAL );

		pnPanel0 = new JPanel();
		GridBagLayout gbPanel0 = new GridBagLayout();
		GridBagConstraints gbcPanel0 = new GridBagConstraints();
		pnPanel0.setLayout(gbPanel0);

		pnPanel1 = new JPanel();
		pnPanel1.setBorder(BorderFactory.createTitledBorder("jChains"));
		GridBagLayout gbPanel1 = new GridBagLayout();
		GridBagConstraints gbcPanel1 = new GridBagConstraints();
		pnPanel1.setLayout(gbPanel1);

		tbpPanel0 = new JTabbedPane();

		pnPanel2 = new JPanel();
		pnPanel2.setBorder(BorderFactory.createTitledBorder("Status"));
		GridBagLayout gbPanel2 = new GridBagLayout();
		GridBagConstraints gbcPanel2 = new GridBagConstraints();
		pnPanel2.setLayout(gbPanel2);

		lbLabel4 = new JLabel("Date:");
		gbcPanel2.gridx = 0;
		gbcPanel2.gridy = 0;
		gbcPanel2.gridwidth = 1;
		gbcPanel2.gridheight = 1;
		gbcPanel2.fill = GridBagConstraints.BOTH;
		gbcPanel2.weightx = 0;
		gbcPanel2.weighty = 1;
		gbcPanel2.anchor = GridBagConstraints.NORTH;
		gbPanel2.setConstraints(lbLabel4, gbcPanel2);
		pnPanel2.add(lbLabel4);

		tfTxtDate = new JTextField();
		gbcPanel2.gridx = 1;
		gbcPanel2.gridy = 0;
		gbcPanel2.gridwidth = 10;
		gbcPanel2.gridheight = 1;
		gbcPanel2.fill = GridBagConstraints.BOTH;
		gbcPanel2.weightx = 1;
		gbcPanel2.weighty = 0;
		gbcPanel2.anchor = GridBagConstraints.NORTH;
		gbPanel2.setConstraints(tfTxtDate, gbcPanel2);
		pnPanel2.add(tfTxtDate);

		lbLabel0 = new JLabel("Count:");
		gbcPanel2.gridx = 0;
		gbcPanel2.gridy = 1;
		gbcPanel2.gridwidth = 1;
		gbcPanel2.gridheight = 1;
		gbcPanel2.fill = GridBagConstraints.BOTH;
		gbcPanel2.weightx = 0;
		gbcPanel2.weighty = 1;
		gbcPanel2.anchor = GridBagConstraints.NORTH;
		gbPanel2.setConstraints(lbLabel0, gbcPanel2);
		pnPanel2.add(lbLabel0);

		tfTxtTime = new JTextField();
		gbcPanel2.gridx = 1;
		gbcPanel2.gridy = 1;
		gbcPanel2.gridwidth = 10;
		gbcPanel2.gridheight = 1;
		gbcPanel2.fill = GridBagConstraints.BOTH;
		gbcPanel2.weightx = 1;
		gbcPanel2.weighty = 0;
		gbcPanel2.anchor = GridBagConstraints.NORTH;
		gbPanel2.setConstraints(tfTxtTime, gbcPanel2);
		pnPanel2.add(tfTxtTime);

		lbLabel8 = new JLabel("Mode:");
		gbcPanel2.gridx = 0;
		gbcPanel2.gridy = 2;
		gbcPanel2.gridwidth = 1;
		gbcPanel2.gridheight = 1;
		gbcPanel2.fill = GridBagConstraints.BOTH;
		gbcPanel2.weightx = 0;
		gbcPanel2.weighty = 1;
		gbcPanel2.anchor = GridBagConstraints.NORTH;
		gbPanel2.setConstraints(lbLabel8, gbcPanel2);
		pnPanel2.add(lbLabel8);

		tfTxtMode = new JTextField();
		gbcPanel2.gridx = 1;
		gbcPanel2.gridy = 2;
		gbcPanel2.gridwidth = 10;
		gbcPanel2.gridheight = 1;
		gbcPanel2.fill = GridBagConstraints.BOTH;
		gbcPanel2.weightx = 1;
		gbcPanel2.weighty = 0;
		gbcPanel2.anchor = GridBagConstraints.NORTH;
		gbPanel2.setConstraints(tfTxtMode, gbcPanel2);
		pnPanel2.add(tfTxtMode);

		pnPanel6 = new JPanel();
		pnPanel6.setBorder(BorderFactory.createTitledBorder("Last Permission"));
		GridBagLayout gbPanel6 = new GridBagLayout();
		GridBagConstraints gbcPanel6 = new GridBagConstraints();
		pnPanel6.setLayout(gbPanel6);

		lbLabel15 = new JLabel("Type");
		lbLabel15.setHorizontalAlignment(2);
		gbcPanel6.gridx = 2;
		gbcPanel6.gridy = 0;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 1;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(lbLabel15, gbcPanel6);
		pnPanel6.add(lbLabel15);

		lbLabel19 = new JLabel("Target");
		lbLabel19.setHorizontalAlignment(2);
		gbcPanel6.gridx = 3;
		gbcPanel6.gridy = 0;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 1;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(lbLabel19, gbcPanel6);
		pnPanel6.add(lbLabel19);

		lbLabel22 = new JLabel("Actions");
		lbLabel22.setHorizontalAlignment(2);
		gbcPanel6.gridx = 4;
		gbcPanel6.gridy = 0;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 1;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(lbLabel22, gbcPanel6);
		pnPanel6.add(lbLabel22);

		tfPermType = new JTextField();
		gbcPanel6.gridx = 2;
		gbcPanel6.gridy = 1;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 0;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(tfPermType, gbcPanel6);
		pnPanel6.add(tfPermType);

		tfPermTarget = new JTextField();
		gbcPanel6.gridx = 3;
		gbcPanel6.gridy = 1;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 0;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(tfPermTarget, gbcPanel6);
		pnPanel6.add(tfPermTarget);

		tfPermActions = new JTextField();
		gbcPanel6.gridx = 4;
		gbcPanel6.gridy = 1;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 0;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(tfPermActions, gbcPanel6);
		pnPanel6.add(tfPermActions);

		lbLabel24 = new JLabel("Time");
		lbLabel24.setHorizontalAlignment(2);
		gbcPanel6.gridx = 0;
		gbcPanel6.gridy = 0;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 1;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(lbLabel24, gbcPanel6);
		pnPanel6.add(lbLabel24);

		tfPermTime = new JTextField();
		gbcPanel6.gridx = 0;
		gbcPanel6.gridy = 1;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 0;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(tfPermTime, gbcPanel6);
		pnPanel6.add(tfPermTime);

		lbLabel26 = new JLabel("Codebase");
		gbcPanel6.gridx = 1;
		gbcPanel6.gridy = 0;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 1;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(lbLabel26, gbcPanel6);
		pnPanel6.add(lbLabel26);

		tfPermCodebase = new JTextField();
		gbcPanel6.gridx = 1;
		gbcPanel6.gridy = 1;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 0;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(tfPermCodebase, gbcPanel6);
		pnPanel6.add(tfPermCodebase);

		tfPermClass = new JTextField();
		gbcPanel6.gridx = 5;
		gbcPanel6.gridy = 1;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 0;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(tfPermClass, gbcPanel6);
		// pnPanel6.add( tfPermClass );

		lbLabel37 = new JLabel("CallingClass");
		lbLabel37.setHorizontalAlignment(2);
		gbcPanel6.gridx = 5;
		gbcPanel6.gridy = 0;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 1;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(lbLabel37, gbcPanel6);
		// pnPanel6.add( lbLabel37 );

		tfPermMethod = new JTextField();
		gbcPanel6.gridx = 6;
		gbcPanel6.gridy = 1;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 0;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(tfPermMethod, gbcPanel6);
		// pnPanel6.add( tfPermMethod );

		lbLabel39 = new JLabel("CallingMethod");
		lbLabel39.setHorizontalAlignment(2);
		gbcPanel6.gridx = 6;
		gbcPanel6.gridy = 0;
		gbcPanel6.gridwidth = 1;
		gbcPanel6.gridheight = 1;
		gbcPanel6.fill = GridBagConstraints.BOTH;
		gbcPanel6.weightx = 1;
		gbcPanel6.weighty = 1;
		gbcPanel6.anchor = GridBagConstraints.NORTH;
		gbPanel6.setConstraints(lbLabel39, gbcPanel6);
		// pnPanel6.add( lbLabel39 );
		gbcPanel2.gridx = 0;
		gbcPanel2.gridy = 8;
		gbcPanel2.gridwidth = 11;
		gbcPanel2.gridheight = 1;
		gbcPanel2.fill = GridBagConstraints.HORIZONTAL;
		gbcPanel2.weightx = 1;
		gbcPanel2.weighty = 0;
		gbcPanel2.anchor = GridBagConstraints.NORTH;
		gbPanel2.setConstraints(pnPanel6, gbcPanel2);
		pnPanel2.add(pnPanel6);

		lbLabel28 = new JLabel("Path of LogFile:");
		gbcPanel2.gridx = 0;
		gbcPanel2.gridy = 3;
		gbcPanel2.gridwidth = 1;
		gbcPanel2.gridheight = 1;
		gbcPanel2.fill = GridBagConstraints.BOTH;
		gbcPanel2.weightx = 0;
		gbcPanel2.weighty = 1;
		gbcPanel2.anchor = GridBagConstraints.NORTH;
		gbPanel2.setConstraints(lbLabel28, gbcPanel2);
		pnPanel2.add(lbLabel28);

		tfTxtLog = new JTextField();
		gbcPanel2.gridx = 1;
		gbcPanel2.gridy = 3;
		gbcPanel2.gridwidth = 10;
		gbcPanel2.gridheight = 1;
		gbcPanel2.fill = GridBagConstraints.BOTH;
		gbcPanel2.weightx = 1;
		gbcPanel2.weighty = 0;
		gbcPanel2.anchor = GridBagConstraints.NORTH;
		gbPanel2.setConstraints(tfTxtLog, gbcPanel2);
		pnPanel2.add(tfTxtLog);

		lbLabel30 = new JLabel("Path of PolicyFile:");
		gbcPanel2.gridx = 0;
		gbcPanel2.gridy = 4;
		gbcPanel2.gridwidth = 1;
		gbcPanel2.gridheight = 1;
		gbcPanel2.fill = GridBagConstraints.BOTH;
		gbcPanel2.weightx = 0;
		gbcPanel2.weighty = 1;
		gbcPanel2.anchor = GridBagConstraints.NORTH;
		gbPanel2.setConstraints(lbLabel30, gbcPanel2);
		pnPanel2.add(lbLabel30);

		tfTxtPolicy = new JTextField();
		gbcPanel2.gridx = 1;
		gbcPanel2.gridy = 4;
		gbcPanel2.gridwidth = 10;
		gbcPanel2.gridheight = 1;
		gbcPanel2.fill = GridBagConstraints.BOTH;
		gbcPanel2.weightx = 1;
		gbcPanel2.weighty = 0;
		gbcPanel2.anchor = GridBagConstraints.NORTH;
		gbPanel2.setConstraints(tfTxtPolicy, gbcPanel2);
		pnPanel2.add(tfTxtPolicy);
//		tbpPanel0.addTab("Status", pnPanel2);

		pnPermissions = new JPanel();
		pnPermissions.setBorder(BorderFactory
				.createTitledBorder("PermissionRequests"));
		GridBagLayout gbPanel3 = new GridBagLayout();
		GridBagConstraints gbcPanel3 = new GridBagConstraints();
		pnPermissions.setLayout(gbPanel3);

		tbPermissions = new PermissionsTable();
		scpPermissions = new JScrollPane(tbPermissions);
		gbcPanel3.gridx = 0;
		gbcPanel3.gridy = 0;
		gbcPanel3.gridwidth = 11;
		gbcPanel3.gridheight = 3;
		gbcPanel3.fill = GridBagConstraints.BOTH;
		gbcPanel3.weightx = 1;
		gbcPanel3.weighty = 1;
		gbcPanel3.anchor = GridBagConstraints.NORTH;
		gbPanel3.setConstraints(scpPermissions, gbcPanel3);
		pnPermissions.add(scpPermissions);
		tbpPanel0.addTab("PermissionRequests", pnPermissions);
		//tbpPanel0.addTab("Perms", new TestTable());

		pnPanel4 = new JPanel();
		pnPanel4.setBorder(BorderFactory.createTitledBorder("Environment"));
		GridBagLayout gbPanel4 = new GridBagLayout();
		GridBagConstraints gbcPanel4 = new GridBagConstraints();
		pnPanel4.setLayout(gbPanel4);

		tbEnvironment = new JTable();
		tbEnvironment.setToolTipText("the environment of the running program");
		JScrollPane scpEnvironment = new JScrollPane(tbEnvironment);
		gbcPanel4.gridx = 0;
		gbcPanel4.gridy = 0;
		gbcPanel4.gridwidth = 12;
		gbcPanel4.gridheight = 5;
		gbcPanel4.fill = GridBagConstraints.BOTH;
		gbcPanel4.weightx = 1;
		gbcPanel4.weighty = 1;
		gbcPanel4.anchor = GridBagConstraints.CENTER;
		gbPanel4.setConstraints(scpEnvironment, gbcPanel4);
		pnPanel4.add(scpEnvironment);
//		tbpPanel0.addTab("Environment", pnPanel4);

		pnPanel5 = new JPanel();
		pnPanel5.setBorder(BorderFactory.createTitledBorder("PolicyFile"));
		GridBagLayout gbPanel5 = new GridBagLayout();
		GridBagConstraints gbcPanel5 = new GridBagConstraints();
		pnPanel5.setLayout(gbPanel5);

		taTxtPolicyFile = new JTextArea(2, 10);
		JScrollPane scpTxtPolicyFile = new JScrollPane(taTxtPolicyFile);
		gbcPanel5.gridx = 0;
		gbcPanel5.gridy = 1;
		gbcPanel5.gridwidth = 11;
		gbcPanel5.gridheight = 2;
		gbcPanel5.fill = GridBagConstraints.BOTH;
		gbcPanel5.weightx = 1;
		gbcPanel5.weighty = 1;
		gbcPanel5.anchor = GridBagConstraints.CENTER;
		gbPanel5.setConstraints(scpTxtPolicyFile, gbcPanel5);
		pnPanel5.add(scpTxtPolicyFile);

		pnPanel15 = new JPanel();
		pnPanel15.setBorder(BorderFactory.createTitledBorder("Save"));
		GridBagLayout gbPanel15 = new GridBagLayout();
		GridBagConstraints gbcPanel15 = new GridBagConstraints();
		pnPanel15.setLayout(gbPanel15);

		btBtnSave = new JButton("Save As..");
		gbcPanel15.gridx = 0;
		gbcPanel15.gridy = 1;
		gbcPanel15.gridwidth = 1;
		gbcPanel15.gridheight = 1;
		gbcPanel15.fill = GridBagConstraints.HORIZONTAL;
		gbcPanel15.weightx = 1;
		gbcPanel15.weighty = 0;
		gbcPanel15.anchor = GridBagConstraints.NORTH;
		gbPanel15.setConstraints(btBtnSave, gbcPanel15);
		pnPanel15.add(btBtnSave);

		tfTxtFilename = new JTextField();
		gbcPanel15.gridx = 0;
		gbcPanel15.gridy = 0;
		gbcPanel15.gridwidth = 1;
		gbcPanel15.gridheight = 1;
		gbcPanel15.fill = GridBagConstraints.BOTH;
		gbcPanel15.weightx = 1;
		gbcPanel15.weighty = 0;
		gbcPanel15.anchor = GridBagConstraints.NORTH;
		gbPanel15.setConstraints(tfTxtFilename, gbcPanel15);
		pnPanel15.add(tfTxtFilename);
		gbcPanel5.gridx = 9;
		gbcPanel5.gridy = 0;
		gbcPanel5.gridwidth = 1;
		gbcPanel5.gridheight = 1;
		gbcPanel5.fill = GridBagConstraints.BOTH;
		gbcPanel5.weightx = 1;
		gbcPanel5.weighty = 0;
		gbcPanel5.anchor = GridBagConstraints.NORTH;
		gbPanel5.setConstraints(pnPanel15, gbcPanel5);
		// pnPanel5.add( pnPanel15 );

		pnPanel16 = new JPanel();
		//pnPanel16.setBorder(BorderFactory.createTitledBorder("Optimize"));
		pnPanel16.setBorder(BorderFactory.createTitledBorder("Copy Policyfile to clipboard"));
		GridBagLayout gbPanel16 = new GridBagLayout();
		GridBagConstraints gbcPanel16 = new GridBagConstraints();
		pnPanel16.setLayout(gbPanel16);
		

		//btBntOptimize = new JButton("Optimize");
		btBntOptimize = new JButton("Copy Policyfile to clipboard");
		btBntOptimize.addActionListener(this);
		//btBntOptimize.setActionCommand("Save");
		gbcPanel16.gridx = 0;
		gbcPanel16.gridy = 0;
		gbcPanel16.gridwidth = 1;
		gbcPanel16.gridheight = 1;
		gbcPanel16.fill = GridBagConstraints.HORIZONTAL;
		gbcPanel16.weightx = 1;
		gbcPanel16.weighty = 0;
		gbcPanel16.anchor = GridBagConstraints.SOUTH;
		gbPanel16.setConstraints(btBntOptimize, gbcPanel16);
		pnPanel16.add(btBntOptimize);
		gbcPanel5.gridx = 10;
		gbcPanel5.gridy = 0;
		gbcPanel5.gridwidth = 1;
		gbcPanel5.gridheight = 1;
		gbcPanel5.fill = GridBagConstraints.BOTH;
		gbcPanel5.weightx = 1;
		gbcPanel5.weighty = 0;
		gbcPanel5.anchor = GridBagConstraints.NORTH;
		gbPanel5.setConstraints(pnPanel16, gbcPanel5);
		pnPanel5.add( pnPanel16 );
		tbpPanel0.addTab("PolicyFile", pnPanel5);

		pnPanel14 = new JPanel();
		GridBagLayout gbPanel14 = new GridBagLayout();
		GridBagConstraints gbcPanel14 = new GridBagConstraints();
		pnPanel14.setLayout(gbPanel14);

		taTxtAboutaa = new JTextArea(2, 10);
		gbcPanel14.gridx = 0;
		gbcPanel14.gridy = 0;
		gbcPanel14.gridwidth = 13;
		gbcPanel14.gridheight = 8;
		gbcPanel14.fill = GridBagConstraints.BOTH;
		gbcPanel14.weightx = 1;
		gbcPanel14.weighty = 1;
		gbcPanel14.anchor = GridBagConstraints.NORTH;
		gbPanel14.setConstraints(taTxtAboutaa, gbcPanel14);
		pnPanel14.add(taTxtAboutaa);
		tbpPanel0.addTab("About", pnPanel14);
		gbcPanel1.gridx = 0;
		gbcPanel1.gridy = 0;
		gbcPanel1.gridwidth = 20;
		gbcPanel1.gridheight = 18;
		gbcPanel1.fill = GridBagConstraints.BOTH;
		gbcPanel1.weightx = 1;
		gbcPanel1.weighty = 1;
		gbcPanel1.anchor = GridBagConstraints.NORTH;
		gbPanel1.setConstraints(tbpPanel0, gbcPanel1);
		pnPanel1.add(tbpPanel0);
		gbcPanel0.gridx = 0;
		gbcPanel0.gridy = 0;
		gbcPanel0.gridwidth = 68;
		gbcPanel0.gridheight = 55;
		gbcPanel0.fill = GridBagConstraints.BOTH;
		gbcPanel0.weightx = 1;
		gbcPanel0.weighty = 1;
		gbcPanel0.anchor = GridBagConstraints.NORTH;
		gbPanel0.setConstraints(pnPanel1, gbcPanel0);
		pnPanel0.add(pnPanel1);

		setDefaultCloseOperation(DISPOSE_ON_CLOSE);

		setContentPane(pnPanel0);
		tbpPanel0.setSelectedIndex(0);
		pack();
		
		show();
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
	    StringSelection stringSelection = new StringSelection( this.taTxtPolicyFile.getText() );
	    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
	    clipboard.setContents(stringSelection, this );
	    
		// TODO Auto-generated method stub
		
	}

	@Override
	public void lostOwnership(Clipboard clipboard, Transferable contents) {
		System.out.println("Lost clipboard");
		// TODO Auto-generated method stub
		
	}
}