package org.jchains.receiver.gui;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import org.jchains.receiver.Perm;

public class PermTableModel extends DefaultTableModel {

	static String iclstring = "<illegal column lookup>";

	static String[] tablenames = new String[] { "Time", "Codebase",
			"Permission", "Target", "Actions", "Class", "Method", "Line" };



	static Vector<String> colnames;
	JTable jt ;

	public static Vector<String> getColumnNamesVect() {
		if (colnames == null) {
			colnames = new Vector<String>();
			for (int i = 0; i < tablenames.length; i++) {
				colnames.add(tablenames[i]);
			}
		}
		return colnames;
	}

	public static String[] getColumnNames() {
		return tablenames.clone();
	}

	
	public void setTable(JTable _jt ) {
		jt = _jt;
	}
	private static final long serialVersionUID = 1L;

	private Vector<Perm> perms = new Vector<Perm>();

	public PermTableModel(Vector<Perm> _perms) {
		System.out.println("perms:" + _perms);
		perms = _perms;
	}

	public PermTableModel() {
		perms = new Vector<Perm>();
		System.out.println("perms:" + perms);
	}

	public void setPerms(Vector<Perm> _perms) {
		System.out.println("perms:" + _perms);
		perms = _perms;

		fireTableDataChanged();
	}

	public String getColumnName(int column) {
		return tablenames[column];
	}

	public int getColumnCount() {
		return tablenames.length;

	}

	public Class getColumnClass(int c) {
		return String.class;
	}
	
	public void addPerm(Perm p) {
// 
		perms.add(p);
		//addRow(p.getRowObject());
	}

	public int getRowCount() {
		// System.out.println("perms:" + perms);
		if (perms == null) {
			perms = new Vector<Perm>();
		}
//		System.out.println(perms.size());
		return perms.size();

	}

	static SimpleDateFormat sds = new SimpleDateFormat();
	static Date the_date = new Date();

	public static String getShortTimeFromLong(long t) {
		the_date.setTime(t);
		return sds.format(the_date);
	}

	public Object getValueAt(int therowIndex, int columnIndex) {
		
		
		int rowIndex = therowIndex; //  jt.convertRowIndexToModel(therowIndex) ;

		
		if (rowIndex <0) {
			return "";
		}
		
		if (perms.size() < rowIndex)
			return "";
		Perm p = perms.elementAt(rowIndex);
		if (columnIndex == 0)
			return getShortTimeFromLong(p.getTime());
		if (columnIndex == 1)
			return p.getCodebase();
		if (columnIndex == 2)
			return p.getPname();
		if (columnIndex == 3)
			return p.getTarget();
		if (columnIndex == 4)
			return p.getFlatActions();
		if (columnIndex == 5)
			return p.getClassname();
		if (columnIndex == 6)
			return p.getMethodname();
		if (columnIndex == 7)
			return Integer.toString(p.getNumber());

		return iclstring;
	}

	public void setValueAt(Object value,int row, int col) {
		System.out.println(value+":"+row+":"+col);
	}
	
}
