package org.jchains.receiver.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JTable;

public class DebugMouseAdapter extends MouseAdapter {

	JTable m_jt;

	public DebugMouseAdapter(JTable jt) {
		m_jt = jt;
	}

	public void mouseClicked(MouseEvent e) {
		printDebugData(m_jt, e);
	}

	private void printDebugData(JTable table, MouseEvent e) {

		int numRows = table.getRowCount();
		int numCols = table.getColumnCount();
		javax.swing.table.TableModel model = table.getModel();
		System.out.println("MouseEvent:" + e);
		System.out.println("================");
		System.out.println("Value of data: ");
		for (int i = 0; i < numRows; i++) {
			System.out.print("    row " + i + ":");
			for (int j = 0; j < numCols; j++) {
				System.out.print("  " + model.getValueAt(i, j));
			}
			System.out.println();
		}
		System.out.println("--------------------------");
	}
}
