package org.jchains.intercept;

import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Hashtable;

class CodeSourceForClass extends Hashtable {

	CodeSourceForClass() {
	}

	String put(Class c) {
		if (!contains(c)) {
			String cs_str = getCodeSourceFromClass(c);
			super.put(c, cs_str);
			return cs_str;
		} else {
			return (String) get(c);
		}
	}

	private String getCodeSourceFromClass(Class c) {
		ProtectionDomain protectiondomain = c.getProtectionDomain();
		CodeSource cs = protectiondomain.getCodeSource();
		URL cs_loc = cs.getLocation();
		String cs_str = cs_loc != null ? cs_loc.toString() : "";
		return cs_str;
	}
}


//class CodeSourceForClass extends Hashtable<Class, String> {
//
//	String put(Class c) {
//		// private String getCodeSourceFromClass(Class c) {
//
//		if (!contains(c)) {
//			String cs_str = getCodeSourceFromClass(c);
//			// ProtectionDomain protectiondomain = c.getProtectionDomain();
//			// // System.out.println("emit" + permission);
//			//
//			// CodeSource cs = protectiondomain.getCodeSource();
//			// URL cs_loc = cs.getLocation();
//			// String cs_str = cs_loc == null ? "" : cs_loc.toString();
//			// return cs_str;
//			super.put(c, cs_str);
//			return cs_str;
//		}
//		return get(c);
//	}
//
//	private static String getCodeSourceFromClass(Class c) {
//		ProtectionDomain protectiondomain = c.getProtectionDomain();
//		// System.out.println("emit" + permission);
//
//		CodeSource cs = protectiondomain.getCodeSource();
//		URL cs_loc = cs.getLocation();
//		String cs_str = cs_loc == null ? "" : cs_loc.toString();
//		return cs_str;
//	}